#pragma once

#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/pubsub/commit_consumer.h>

#include <boost/noncopyable.hpp>

#include <vector>

namespace maps {
namespace wiki {
namespace contours {

typedef std::pair<pubsub::CommitId, pubsub::CommitId> CommitRange;

constexpr pubsub::CommitId INVALID_COMMIT_ID = 0;

const pubsub::ConsumerId CONSUMER_ID = "contour-denormalizer";

/**
 * \see https://wiki.yandex-team.ru/maps/dev/core/wikimap/mapspro/pubsub
 */
class PubsubWrapper : boost::noncopyable {
public:
    PubsubWrapper(pqxx::transaction_base& viewTxn, size_t commitsBatchSize);

    /**
     * for first time \return {INVALID_COMMIT_ID, <last commit in the queue>}
     */
    CommitRange consumeBatch(pqxx::transaction_base& revisionTxn);

    /**
     * delete watermark
     */
    void reset();

private:
    pqxx::transaction_base& viewTxn_;
    pubsub::CommitConsumer consumer_;
    bool isFirstTime_;
};

size_t queueSize
    ( pqxx::transaction_base& revisionTxn
    , pqxx::transaction_base& viewTxn
    );

} // contours
} // wiki
} // maps
