#pragma once

#include "common.h"

#include <yandex/maps/wiki/revision/filters.h>

#include <memory>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

enum class CategoryType { Complex, Geom, Attr };

/**
 * Class to describe categories of interest and their dependencies.
 * It is used to prepare filters.
 */
class Categories {
public:
    Categories();
    ~Categories();

    Categories(const Categories&);
    Categories& operator = (const Categories&);

    void addCategory(const TCategoryId& categoryId, CategoryType type);

    void addRelation(
        const TCategoryId& masterCategoryId,
        const TCategoryId& slaveCategoryId,
        const TRoleId& roleId);

    bool isComplex(const TCategoryId& categoryId) const;
    bool isGeom(const TCategoryId& categoryId) const;
    bool isAttr(const TCategoryId& categoryId) const;

    CategoryType type(const TCategoryId& categoryId) const;

    bool isDefined(const TCategoryId& categoryId) const;

    bool hasSlaves(const TCategoryId& categoryId) const;
    bool hasMasters(const TCategoryId& categoryId) const;

    revision::filters::ProxyFilterExpr objectsFilter(CategoryType type) const;
    revision::filters::ProxyFilterExpr relationsFilter() const;

    revision::filters::ProxyFilterExpr categoriesFilter(CategoryType type) const;
    revision::filters::ProxyFilterExpr categoriesFilter(CategoryType type, const TStringSet& categoryIds) const;

    revision::filters::ProxyFilterExpr
    slaveRelationsFilter(const TCategoryId& categoryId) const;

    revision::filters::ProxyFilterExpr
    masterRelationsFilter(const TCategoryId& categoryId) const;

private:
    class Impl;

    std::unique_ptr<Impl> impl_;
};

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
