#pragma once

#include <yandex/maps/wiki/common/geom.h>
#include <yandex/maps/wiki/revision/revisionid.h>
#include <yandex/maps/wiki/revision/objectrevision.h>

#include <pqxx/pqxx>

#include <functional>
#include <list>
#include <string>
#include <set>
#include <vector>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

typedef std::list<std::string> TStringList;
typedef std::set<std::string> TStringSet;

typedef revision::DBID TObjectId;
typedef std::set<TObjectId> TObjectIdSet;

typedef revision::DBID TCommitId;
typedef std::set<TCommitId> TCommitIdSet;

typedef revision::DBID TBranchId;

typedef std::string TCategoryId;
typedef std::set<TCategoryId> TCategoryIdSet;

typedef revision::Attributes TAttributesMap;

typedef std::string TRoleId;

typedef revision::RevisionID TRevisionId;
typedef std::vector<TRevisionId> TRevisionIdVector;

typedef std::list<revision::ObjectRevision> TRevisionList;

typedef common::Geom TGeom;

typedef pqxx::transaction_base Transaction;

typedef std::function<bool(const TCategoryId&)> TCategoryPredicate;

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
