#pragma once

#include "categories.h"
#include "common.h"
#include "object.h"
#include "relation.h"

#include <maps/libs/common/include/pimpl_utils.h>

#include <memory>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

class HistoricalSnapshot {
public:
    HistoricalSnapshot
        ( TCommitId minCommitId
        , TCommitId maxCommitId
        , Transaction& txn
        , TBranchId branchId
        , const Categories& categories
        );

    TCommitId minCommitId() const;
    TCommitId maxCommitId() const;

    /**
     * \return IDs of objects of defined categories
     * that affected by changes between min and max commits
     * directly or through relations of \param relationType.
     * Output IDs are filtered by category (\param filter).
     * Example:
     * \code{.cpp}
     * revision_meta::HistoricalSnapshot snapshot
     *     ( minCommit
     *     , maxCommit
     *     , transaction
     *     , TRUNK_BRANCH_ID
     *     , categoriesFromXml
     *     );
     * auto ids = snapshot.affectedObjects
     *     ( RelationType::Master
     *     , [](const TCategoryId& cat) { return cat == "ad"; }
     *     );
     * // UPDATE vrevisions_trunk.contour_objects_geom
     * \endcode
     */
    TObjectIdSet
    affectedObjects(RelationType relationType, TCategoryPredicate filter);

    MOVABLE_PIMPL_DECLARATIONS(HistoricalSnapshot)
};

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
