#include "object.h"

#include "object_data.h"

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

Object::Object(const revision::ObjectRevision& rev)
    : data_(new Object::Data(rev))
{}

Object::Object(const Object& oth)
    : data_(new Object::Data(*oth.data_))
{}

Object& Object::operator = (const Object& oth)
{
    *data_ = *oth.data_;
    return *this;
}

Object::~Object() {}

TObjectId Object::objectId() const { return data_->objectId; }

TCommitId Object::commitId() const { return data_->commitId; }

const TCategoryId& Object::categoryId() const { return data_->categoryId; }

const TAttributesMap& Object::attrs() const { return data_->attrs; }

ObjectState Object::state() const { return data_->state; }

const TGeom& Object::geom() const { return data_->geom; }

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
