#pragma once

#include "common.h"

#include <memory>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

enum class ObjectState { New, Deleted, Existing };

class Object {
public:
    explicit Object(const revision::ObjectRevision& rev);

    Object(const Object&);
    Object& operator = (const Object&);

    virtual ~Object();

    TObjectId objectId() const;
    TCommitId commitId() const;

    const TCategoryId& categoryId() const;
    const TAttributesMap& attrs() const;

    ObjectState state() const;

    const TGeom& geom() const;

protected:
    struct Data;

    std::unique_ptr<Data> data_;
};

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
