#pragma once

#include "object.h"

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

struct Object::Data {
    explicit Data(const revision::ObjectRevision& rev)
        : objectId(rev.id().objectId())
        , commitId(rev.id().commitId())
    {
        if (rev.data().deleted) {
            state = ObjectState::Deleted;
        } else if (!rev.prevId().valid()) {
            state = ObjectState::New;
        } else {
            state = ObjectState::Existing;
        }

        REQUIRE(rev.data().attributes, "Revision " << rev.id() << " has no attributes");
        attrs = *rev.data().attributes;

        for (const auto& attr : attrs) {
            if (attr.first.find("cat:") != 0) {
                continue;
            }
            const auto& catSubstr = attr.first.substr(4, std::string::npos);
            REQUIRE(categoryId.empty(),
                "Object " << rev.id() << "category is already set to " << categoryId
                    << ", trying to redefine with " << catSubstr);
            categoryId = catSubstr;
        }
        REQUIRE(!categoryId.empty(), "Object " << rev.id() << " category undefined");

        if (rev.data().geometry) {
            geom = TGeom(*rev.data().geometry);
        }
    }

    TObjectId objectId;
    TCommitId commitId;

    TCategoryId categoryId;
    TAttributesMap attrs;

    ObjectState state;

    TGeom geom;
};

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
