#include "relation.h"

#include "relation_data.h"

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

Relation::Relation(const revision::ObjectRevision& rev)
    : data_(new Relation::Data(rev))
{}

Relation::~Relation() {}

TObjectId Relation::relationId() const { return data_->relationId; }
TCommitId Relation::commitId() const { return data_->commitId; }

ObjectState Relation::state() const { return data_->state; }

TObjectId Relation::masterId() const { return data_->masterId; }
const TCategoryId& Relation::masterCategoryId() const { return data_->masterCategoryId; }

TObjectId Relation::slaveId() const { return data_->slaveId; }
const TCategoryId& Relation::slaveCategoryId() const { return data_->slaveCategoryId; }

const TRoleId& Relation::roleId() const { return data_->roleId; }

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
