#pragma once

#include "common.h"
#include "object.h"

#include <memory>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

enum class RelationType { Master, Slave };

const std::string REL_MASTER = "rel:master";
const std::string REL_SLAVE = "rel:slave";
const std::string REL_ROLE = "rel:role";

class Relation {
public:
    explicit Relation(const revision::ObjectRevision& rev);

    virtual ~Relation();

    TObjectId relationId() const;
    TCommitId commitId() const;

    ObjectState state() const;

    TObjectId masterId() const;
    const TCategoryId& masterCategoryId() const;
    TObjectId slaveId() const;
    const TCategoryId& slaveCategoryId() const;

    const TRoleId& roleId() const;

protected:
    struct Data;

    std::unique_ptr<Data> data_;
};

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
