#pragma once

#include "common.h"
#include "categories.h"
#include "relation.h"

#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <yandex/maps/wiki/revision/branch.h>

#include <memory>

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

class RevisionsLoader {
public:
    RevisionsLoader(
        Transaction& txn,
        TBranchId branchId,
        const Categories& categories);

    TRevisionList
    loadRelations(TCommitId minCommitId, TCommitId maxCommitId) const;

    TRevisionList loadRelations(
        RelationType relationType,
        const TCategoryId& categoryId,
        const TObjectIdSet& objectIds,
        TCommitId maxCommitId) const;

    TRevisionList loadNotDeletedRelations(
        RelationType relationType,
        const TObjectIdSet& objectIds,
        TCommitId maxCommitId) const;

    TRevisionIdVector
    loadObjectIds(TCommitId minCommitId, TCommitId maxCommitId) const;

    TRevisionIdVector
    loadObjectIds(const TObjectIdSet& objectIds, TCommitId maxCommitId) const;

    TRevisionList loadObjects(const TRevisionIdVector& revisionIds) const;

    TRevisionIdVector
    loadObjectIds(
        CategoryType hintCategoryType,
        const TObjectIdSet& objectIds,
        TCommitId maxCommitId) const;

    TRevisionList loadObjects(
        CategoryType hintCategoryType,
        const TRevisionIdVector& revisionIds) const;

    const Categories& categories() const { return categories_; }

private:
    revision::RevisionsGateway gateway_;
    const Categories& categories_;
};

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
