#include "snapshot.h"

#include "snapshot_impl.h"

namespace maps {
namespace wiki {
namespace contours {
namespace revision_meta {

Snapshot::Snapshot(
        TCommitId headCommitId,
        Transaction& txn,
        TBranchId branchId,
        const Categories& categories)
    : impl_(new Impl(headCommitId, txn, branchId, categories))
{}

TCommitId Snapshot::headCommitId() const { return impl_->headCommitId(); }


const Object*
Snapshot::tryGetObjectRevision(TObjectId objectId) const
{
    return impl_->tryGetObjectRevision(objectId, headCommitId());
}

const Object&
Snapshot::objectRevision(TObjectId objectId) const
{
    return impl_->objectRevision(objectId, headCommitId());
}

const Object&
Snapshot::existingObjectRevision(TObjectId objectId) const
{
    return impl_->existingObjectRevision(objectId, headCommitId());
}

TObjectIdSet
Snapshot::slaves(TObjectId objectId) const
{
    return impl_->slaves(objectId, headCommitId());
}

TObjectIdSet
Snapshot::masters(TObjectId objectId) const
{
    return impl_->masters(objectId, headCommitId());
}

TObjectIdSet
Snapshot::loadObjects(const TObjectIdSet& objectIds)
{
    return impl_->loadObjects(objectIds);
}

void
Snapshot::loadSlaves(const TObjectIdSet& objectIds)
{
    return impl_->loadRelatives(RelationType::Slave, objectIds);
}

void
Snapshot::loadSlavesRecursive(const TObjectIdSet& objectIds)
{
    return impl_->loadRelativesRecursive(RelationType::Slave, objectIds);
}

void
Snapshot::loadMasters(const TObjectIdSet& objectIds)
{
    return impl_->loadRelatives(RelationType::Master, objectIds);
}

void
Snapshot::loadMastersRecursive(const TObjectIdSet& objectIds)
{
    return impl_->loadRelativesRecursive(RelationType::Master, objectIds);
}

MOVABLE_PIMPL_DEFINITIONS(Snapshot)

} // namespace revision_meta
} // namespace contours
} // namespace wiki
} // namespace maps
