#pragma once

#include <yandex/maps/mds/mds.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/mds_dataset/dataset_gateway.h>
#include <yandex/maps/wiki/mds_dataset/export_metadata.h>

#include <set>

namespace maps {
namespace wiki {
namespace exporter {
namespace cleaner {

void deleteObsoleteDatasets(
    pgpool3::Pool& pool,
    mds::Mds& mds,
    mds_dataset::Subset subset,
    size_t maxAgeDays);

void deleteRedundantDatasets(
    pgpool3::Pool& pool,
    mds::Mds& mds,
    mds_dataset::DatasetStatus status,
    mds_dataset::Subset subset,
    mds_dataset::Region region,
    size_t numTotalToKeep,
    size_t numTestedToKeep = 0);

std::set<mds_dataset::Region> loadAllRegions(
    pgpool3::Pool& pool,
    mds_dataset::Subset subset);

} // cleaner
} // exporter
} // wiki
} // maps
