#include <maps/wikimap/mapspro/services/tasks_realtime/src/mrc_pedestrian_regions_logger/lib/common.h>

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/pubsub/commit_consumer.h>

#include <iostream>

namespace {

constexpr size_t WARN_QUEUE_SIZE = 50000;
constexpr size_t ERROR_QUEUE_SIZE = 2 * WARN_QUEUE_SIZE;

} // namespace

using namespace maps::wiki;
using namespace maps::wiki::tasks;


int main() try
{
    maps::log8::setLevel(maps::log8::Level::FATAL);

    auto configPtr = common::loadDefaultConfig();
    common::PoolHolder corePoolHolder(*configPtr, log_mrc_pedestrian_regions::LONG_READ_DB_ID, log_mrc_pedestrian_regions::LONG_READ_POOL_ID);
    auto txn = corePoolHolder.pool().slaveTransaction();

    auto queueSize = pubsub::countCommitsInQueue(
        *txn, *txn, log_mrc_pedestrian_regions::PUBSUB_CONSUMER_ID, revision::TRUNK_BRANCH_ID
    );
    if (queueSize > ERROR_QUEUE_SIZE) {
        std::cout << "2;Error: queue size is " << queueSize << " commits" << std::endl;
    } else if (queueSize > WARN_QUEUE_SIZE) {
        std::cout << "1;Warning: queue size is " << queueSize << " commits" << std::endl;
    } else {
        std::cout << "0;Ok: queue size is " << queueSize << " commits" << std::endl;
    }
    return EXIT_SUCCESS;
} catch (const std::exception& e) {
    std::cout << "2;Error: " << e.what() << std::endl;
    return EXIT_SUCCESS;
}
