#pragma once

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/io.h>

#include <string>

namespace maps::wiki::tasks::log_mrc_pedestrian_regions {

class IYtTableWriter {
public:
    virtual ~IYtTableWriter() = default;

    virtual void addRow(const NYT::TNode& row) = 0;
    virtual void finish() = 0;
};


class YtTableWriter final: public IYtTableWriter {
public:
    YtTableWriter(NYT::ITransactionPtr txn, const TString& path)
    {
        tableWriter_ = txn->CreateTableWriter<NYT::TNode>(
            NYT::TRichYPath(path).Append(true)   // Append rows if table already exists.
        );
    }

    void addRow(const NYT::TNode& row) override
    {
        tableWriter_->AddRow(row);
    }

    void finish() override
    {
        tableWriter_->Finish();
    }

private:
    NYT::TTableWriterPtr<NYT::TNode> tableWriter_;
};

} // namespace maps::wiki::tasks::log_mrc_pedestrian_regions
