#include "mrc_pedestrian_region.h"
#include "strings.h"

#include <maps/libs/geolib/include/serialization.h>
#include <yandex/maps/wiki/common/geom_utils.h>
#include <yandex/maps/wiki/revision/commit.h>
#include <yandex/maps/wiki/common/string_utils.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>


#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/log8/include/log8.h>

namespace rev = maps::wiki::revision;

namespace maps::wiki::tasks::mrc_pedestrian {

namespace {

const std::string DEFAULT_NAME_PREFIX = "Area ";

inline geolib3::Polygon2 readGeometry(const rev::ObjectRevision& rev)
{
    return geolib3::WKB::read<geolib3::Polygon2>(*rev.data().geometry);
}

} // anonymous namespace

MrcPedestrianRegion::MrcPedestrianRegion(const rev::ObjectRevision& rev)
    : objectId_(rev.id().objectId())
    , attributes_(*rev.data().attributes)
    , mercatorPolygon_(readGeometry(rev))
    , defaultName_(DEFAULT_NAME_PREFIX + std::to_string(objectId_))
{
    auto it = attributes_.find(ATTR_NAME);
    if (it != attributes_.end()) {
        name_ = it->second;
    }

    it = attributes_.find(ATTR_PEDESTRIAN_LOGIN_UID);
    if (it != attributes_.end()) {
        pedestrianUid_ = it->second;
    }

    isIndoor_ = attributes_.contains(ATTR_IS_INDOOR);
    isPanoramic_ = attributes_.contains(ATTR_IS_PANORAMIC);

    it = attributes_.find(ATTR_STATUS);
    if (it == attributes_.end()) {
        WARN() << "Missing status in object " << objectId_;
        status_ = STATUS_DRAFT;
    } else {
        status_ = it->second;
    }
}

} // namespace maps::wiki::tasks::mrc_pedestrian
