#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <yandex/maps/wiki/revision/diff.h>
#include <yandex/maps/wiki/revision/objectrevision.h>

#include <optional>
#include <string>

namespace maps::wiki::tasks::mrc_pedestrian {

class MrcPedestrianRegion
{
public:
    explicit MrcPedestrianRegion(const revision::ObjectRevision& rev);

    revision::DBID objectId() const { return objectId_; }
    const std::string& name() const { return name_ ? *name_ : defaultName_; }
    const std::string& pedestrianUid() const { return pedestrianUid_; }
    const std::string& status() const { return status_; }
    bool isIndoor() const { return isIndoor_; }
    bool isPanoramic() const { return isPanoramic_; }

    const geolib3::Polygon2 mercatorPolygon() const { return mercatorPolygon_; }

private:
    revision::DBID objectId_;
    revision::Attributes attributes_;

    geolib3::Polygon2 mercatorPolygon_;

    std::optional<std::string> name_;
    std::string defaultName_;
    std::string pedestrianUid_;
    std::string status_;
    bool isIndoor_;
    bool isPanoramic_;
};

} // namespace maps::wiki::tasks::mrc_pedestrian
