#pragma once

#include <maps/libs/auth/include/tvm.h>

#include <string>

namespace maps::wiki::tasks::mrc_pedestrian {

class ServiceTicketProvider
{
public:
    virtual std::string getTicketFor(const std::string& destAlias) = 0;
    virtual ~ServiceTicketProvider() {}
};


class TvmtoolServiceTicketProvider : public ServiceTicketProvider
{
public:
    TvmtoolServiceTicketProvider()
       : tvmClient_(auth::TvmtoolSettings().makeTvmClient())
    {}

    std::string getTicketFor(const std::string& destAlias) override
    {
        return tvmClient_.GetServiceTicketFor(TString{destAlias});
    }

private:
    NTvmAuth::TTvmClient tvmClient_;
};


class FixedServiceTicketProvider : public ServiceTicketProvider
{
public:
    FixedServiceTicketProvider(std::string ticket)
       : ticket_(std::move(ticket))
    {}

    std::string getTicketFor(const std::string& /*destAlias*/) override
    {
        return ticket_;
    }

private:
    const std::string ticket_;
};

} // namespace maps::wiki::tasks::mrc_pedestrian
