#pragma once

#include "service_ticket_provider.h"

#include <maps/libs/http/include/http.h>
#include <maps/libs/geolib/include/polygon.h>
#include <maps/streetview/backoffice/tools/mrc_targets/include/mrc_target.h>
#include <yandex/maps/proto/ugc_account/assignment.pb.h>

#include <memory>
#include <string>

namespace maps::wiki::tasks::mrc_pedestrian {

class UgcBackofficeClient
{
public:
    UgcBackofficeClient(
        std::string ugcBackofficeHost,
        std::unique_ptr<ServiceTicketProvider> serviceTicketProvider);

    void createAssignment(
        const std::string& taskId,
        const std::string& name,
        const std::string& uid,
        const geolib3::Polygon2& mercatorPolygon,
        bool isIndoor,
        bool isPanoramic,
        const std::vector<streetview::MrcTarget>& panoramaTargets);

    void deleteAssignment(const std::string taskId, const std::string& uid);

    // returns nullopt if assignment does not exist
    std::optional<yandex::maps::proto::ugc_account::assignment::Status>
    getAssignmentStatus(const std::string& taskId, const std::string& uid);

private:
    std::string ugcBackofficeHost_;
    http::Client httpClient_;

    std::unique_ptr<ServiceTicketProvider> serviceTicketProvider_;
};

} // namespace maps::wiki::tasks::mrc_pedestrian
