#pragma once

#include "translator.h"

#include <yandex/maps/wiki/common/geom.h>
#include <yandex/maps/wiki/common/tskv_logger.h>
#include <yandex/maps/wiki/revision/commit.h>
#include <yandex/maps/wiki/revision/diff.h>
#include <yandex/maps/wiki/revision/objectrevision.h>

namespace maps {
namespace wiki {
namespace tasks {
namespace outsource_regions {

class OutsourceRegion
{
public:
    explicit OutsourceRegion(const revision::ObjectRevision& rev);

    revision::DBID objectId() const { return objectId_; }
    const std::string& name() const { return name_.empty() ? defaultName_ : name_; }
    const std::string& companyId() const { return companyId_; }
    const std::string& parentStKey() const { return parentStKey_; }

    const std::string& stKey() const { return stKey_; }
    void setStKey(std::string key) { stKey_ = std::move(key); }

    const std::string& nproHost() const { return nproHost_; }
    void setNproHost(std::string host) { nproHost_ = std::move(host); }

    void updateAttributes(const revision::AttributesDiff& attrsDiff);
    void updateGeometry(const revision::GeometryDiff& geomDiff);

    std::string description(
        revision::DBID commitId,
        const std::string& login,
        const Translator& translator) const;

    std::string comment(
        revision::DBID commitId,
        const revision::AttributesDiff& attrsDiff,
        const std::string& login,
        const Translator& translator) const;

    std::string commentAboutDeletion(
        revision::DBID commitId,
        const std::string& login) const;

    common::TskvMessage logMessage(
        const revision::Commit& commit,
        revision::UserID userId) const;

private:
    std::string nproLink() const;

    revision::DBID objectId_;
    revision::Attributes attributes_;
    common::Geom geometry_;

    std::string name_;
    std::string defaultName_;
    std::string companyId_;
    std::string parentStKey_;

    std::string stKey_;
    std::string nproHost_;
};

} // namespace outsource_regions
} // namespace tasks
} // namespace wiki
} // namespace maps
