#include "translator.h"

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/secrets.h>
#include <maps/wikimap/mapspro/libs/http/include/yandex/maps/wiki/http/tanker/tanker.h>

#include <boost/algorithm/string/replace.hpp>

namespace maps {
namespace wiki {
namespace tasks {
namespace outsource_regions {

namespace {

const std::string PROJECT_ID = "nmaps";
const std::string LANGUAGE = "ru";

TranslationMap getTranslationMap(const std::string& tankerHost, const std::string& keysetId)
{
    tanker::Gateway gateway(
        {tankerHost, PROJECT_ID, tokenByKey(common::secrets::Key::RobotWikimapTankerToken)}
    );
    return gateway.translations(keysetId, LANGUAGE);
}

} // namespace

Translator::Translator(const std::string& tankerHost)
    : attributes_(getTranslationMap(tankerHost, "attrs"))
    , attributeValues_(getTranslationMap(tankerHost, "attr-values"))
{
}

std::string Translator::attribute(const std::string& attrName) const
{
    auto attrNameFixed = boost::replace_first_copy(attrName, ":", "-");

    auto it = attributes_.find(attrNameFixed);
    if (it != attributes_.end()) {
        return it->second;
    }
    return attrName;
}

std::string Translator::attributeValue(const std::string& attrName, const std::string& attrValue) const
{
    auto attrNameFixed = boost::replace_first_copy(attrName, ":", "-");
    auto attrValueFixed = attrNameFixed + "__" + attrValue;

    auto it = attributeValues_.find(attrValueFixed);
    if (it != attributeValues_.end()) {
        return it->second;
    }
    return attrValue;
}

} // namespace outsource_regions
} // namespace tasks
} // namespace wiki
} // namespace maps
