#pragma once

#include <string>
#include <unordered_map>

namespace maps {
namespace wiki {
namespace tasks {
namespace outsource_regions {

using TranslationMap = std::unordered_map<std::string, std::string>;

class Translator
{
public:
    explicit Translator(const std::string& tankerHost);

    std::string attribute(const std::string& attrName) const;
    std::string attributeValue(const std::string& attrName, const std::string& attrValue) const;

private:
    TranslationMap attributes_;
    TranslationMap attributeValues_;
};

} // namespace outsource_regions
} // namespace tasks
} // namespace wiki
} // namespace maps
