#pragma once

#include <yandex/maps/wiki/common/tskv_logger.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps {
namespace wiki {
namespace tasks {
namespace outsourcer_edits {

class Handler
{
public:
    Handler(pgpool3::Pool& corePool, pgpool3::Pool& socialPool);

    size_t dispatchNewCommits(size_t batchSize);

    void processRange(size_t fromCommit, size_t toCommit, const std::string& logPath);

private:
    void processEvents(
        const social::Events& events,
        pgpool3::TransactionHandle& coreTxn,
        common::TskvLogger& logger);

    pgpool3::Pool& corePool_;
    pgpool3::Pool& socialPool_;
    common::TskvLogger statLogger_;
};

} // namespace outsourcer_edits
} // namespace tasks
} // namespace wiki
} // namespace maps
