#pragma once

#include "branch_events.h"

#include <maps/libs/http/include/http.h>
#include <maps/libs/json/include/value.h>

#include <string_view>

using namespace std::chrono_literals;

namespace maps::wiki::garden {

constexpr std::string_view GARDEN_MODULES_STATISTICS =
    "http://core-garden-server.maps.yandex.net/module_statistics/?module={}&from={}";
constexpr std::string_view GARDEN_BUILD_INFO =
    "http://core-garden-server.maps.yandex.net/modules/{}/build_statistics/{}/";

const auto TIME_OFFSET = 24h;
const std::string DEPLOY_STEP_STABLE = "stable";
const std::string MODULE_YMAPSDF_SRC = "ymapsdf_src";

class IHttpClient
{
public:
    virtual ~IHttpClient() = default;
    virtual json::Value get(const std::string& url) = 0;
};

class HttpClient : public IHttpClient
{
public:
    HttpClient();

    json::Value get(const std::string& url) override;

private:
    http::Client httpClient_;
};

EventsHolder loadBranchDeployedTimes(
    IHttpClient& httpClient,
    const std::string& event,
    const chrono::TimePoint fromTime);

} // namespace maps::wiki::garden
