#include <maps/wikimap/mapspro/services/tasks_realtime/src/skills_updater/lib/auto_experts.h>
#include <maps/wikimap/mapspro/services/tasks_realtime/src/skills_updater/lib/skills_updater.h>

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/pgpool3utils/pg_advisory_mutex.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/pg_advisory_lock_ids.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/configs/editor/config_holder.h>

#include <cstdlib>

namespace {

const std::string EDITOR_CONFIG_NODE = "/config/services/editor/config";

} // namespace

using namespace maps;
using namespace maps::wiki;
using namespace maps::wiki::common;
using namespace maps::wiki::configs;
using namespace maps::wiki::skills_updater;

int
main()
try {
    const auto servicesCfg = loadDefaultConfig();
    auto socialPoolHolder = PoolHolder(*servicesCfg, "social", "grinder");

    pgp3utils::PgAdvisoryXactMutex guard(
        socialPoolHolder.pool(),
        static_cast<int64_t>(AdvisoryLockIds::SKILLS_UPDATER));
    if (!guard.try_lock()) {
        INFO() << "Skills updater is already running. (DB is locked)";
        std::exit(EXIT_SUCCESS);
    }

    social::Gateway socialGw(guard.writableTxn());
    const auto updatedUsers = skills_updater::updateSkills(socialGw);

    auto aclPoolHolder = PoolHolder(*servicesCfg, "core", "grinder");
    auto aclTxnHandle = aclPoolHolder.pool().masterWriteableTransaction();
    acl::ACLGateway aclGw(aclTxnHandle.get());
    const auto editorCfg = editor::ConfigHolder(servicesCfg->node(EDITOR_CONFIG_NODE).value());
    makeExperts(socialGw, aclGw, editorCfg.categoryGroups(), updatedUsers);

    aclTxnHandle->commit();
    guard.writableTxn().commit();

    return EXIT_SUCCESS;
} catch (const Exception& e) {
    FATAL() << "Skills updater has failed: '" << e << "'.";
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    FATAL() << "Skills updater has failed: '" << e.what() << "'.";
    return EXIT_FAILURE;
}
