#include "skills_updater.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/batch.h>
#include <yandex/maps/wiki/social/gateway.h>

namespace maps::wiki::skills_updater {

namespace {

std::vector<social::TUid> updateActiveUsersSkills(
    social::Gateway& socialGw,
    chrono::TimePoint activityTimeBegin,
    chrono::TimePoint activityTimeEnd)
{
    const auto BATCH_SIZE = 100;

    INFO() << "Skills will be updated for users active from "
           << chrono::formatIsoDate(activityTimeBegin) << " till "
           << chrono::formatIsoDate(activityTimeEnd) << ".";

    auto activeUsers = socialGw.getActiveUserIds(activityTimeBegin, activityTimeEnd);

    INFO() << "Skills will be updated for " << activeUsers.size() << " users.";

    common::applyBatchOp(
        activeUsers, BATCH_SIZE,
        [&](const auto& activeUsersBatch) {
            socialGw.updateSkills(activeUsersBatch);
        }
    );

    return activeUsers;
}

} // namespace


std::vector<social::TUid> updateSkills(social::Gateway& socialGw)
{
    INFO() << "Skills updating has started.";

    const auto yesterdayTimePoint = chrono::TimePoint::clock::now() - chrono::Days(1);
    const auto [yesterdayBegin, yesterdayEnd] = chrono::getComprisingTimeSpan<chrono::Days>(yesterdayTimePoint);
    auto updatedUsers = updateActiveUsersSkills(socialGw, yesterdayBegin, yesterdayEnd);

    INFO() << "Skills updating has finished.";

    return updatedUsers;
}

} // maps::wiki::skills_updater
