#include "profiles.h"

namespace maps::wiki::stat_users_dump_worker {

Profiles::Profiles(const social::Profiles& socialProfiles)
{
    uidToProfile_.reserve(socialProfiles.size());
    for (const auto& profile: socialProfiles) {
        uidToProfile_.emplace(profile.uid(), profile);
    }
}

std::optional<social::Profile> Profiles::getByUid(social::TId uid) const
{
    const auto profileIt = uidToProfile_.find(uid);
    if (profileIt != uidToProfile_.end()) {
        return std::make_optional(profileIt->second);
    }
    return std::nullopt;
}

} // namespace maps::wiki::stat_users_dump_worker
