#pragma once
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <yandex/maps/wiki/social/profile_gateway.h>

#include <string>
#include <vector>
#include <optional>

namespace maps::wiki::stat_users_dump_worker {

class User
{
public:
    User(
        acl::User aclUser,
        std::string moderationStatus,
        const std::optional<social::Profile>& profile);

    void writeUserData(std::ostream& outStream) const;

private:
    const acl::User aclUser_;
    const std::optional<social::Profile> profile_;
    const std::string moderationStatus_;

    std::string registrationDateString() const;
    acl::User::Status userStatus() const;
    std::string locale() const;
    std::string newsSubscriptionString() const;
    std::string newsSubscriptionModifiedAtString() const;
    std::string email() const;
    std::string_view deleteReason() const;
};

using Users = std::vector<User>;

Users getUsersDumpData(
    acl::ACLGateway& aclGateway, social::ProfileGateway& socialProfileGateway);

} // namespace maps::wiki::stat_users_dump_worker
