# pragma once

#include <maps/wikimap/mapspro/services/tasks_realtime/src/user_edits_metrics/lib/util.h>

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>
#include <maps/wikimap/mapspro/libs/revision/include/yandex/maps/wiki/revision/common.h>

#include <pqxx/pqxx>
#include <map>

namespace maps::wiki::user_edits_metrics {

struct MetricsConfig
{
    std::map<revision::DBID, std::string> aoiIdToName;
};

MetricsConfig loadMetricsConfig(const common::ExtendedXmlDoc& cfg);

AoiRegionsData loadAoiRegions(
    pqxx::transaction_base& txnCore,
    const MetricsConfig& metricsConfig);
RegionsData loadRegionsData(pqxx::transaction_base& txnView);
BranchesById loadBranchInfos(pqxx::transaction_base& txnCore);

} // namespace maps::wiki::user_edits_metrics
