#pragma once

#include "commit_data.h"
#include "util.h"

#include <maps/libs/chrono/include/time_point.h>

#include <iosfwd>
#include <optional>
#include <string>
#include <vector>

namespace maps::wiki::user_edits_metrics {

struct Metric
{
    enum class Estimated {Yes, No};

    chrono::TimePoint time;
    std::chrono::seconds value;
    std::chrono::seconds workdaysValue;
    double quantile;
    std::string region;
    std::string userType;
    Event event;
    bool inTrunk;
    Estimated estimated = Estimated::No;

    std::string name() const;
};

using MetricVec = std::vector<Metric>;

std::optional<Metric> quantileMetric(
    const std::vector<CommitData>& commitData,
    const std::string& regionName,
    const std::set<std::string>& eventRegions,
    CommitFilter commitFilter,
    Event event,
    double quantile,
    bool inTrunk,
    const std::string& userType);

} // namespace maps::wiki::user_edits_metrics
