#pragma once

#include "metrics.h"

#include <maps/libs/chrono/include/time_point.h>

#include <vector>

namespace maps::wiki::user_edits_metrics::impl {

MetricVec getMetrics(
    const MetricVec& allMetrics,
    double quantile,
    bool inTrunk,
    const std::string& region,
    const std::string& userType,
    const EventSet& events);

using ConsolidationFunc =
    std::function<std::optional<Metric>(chrono::TimePoint, MetricVec::const_iterator, MetricVec::const_iterator)>;

MetricVec sortAndConsolidateMetricsByDays(
    MetricVec metrics,
    ConsolidationFunc consolidationFunc);

MetricVec sortAndConsolidateDeployedMetricsByDays(
    const MetricVec& deployedMetrics,
    Event consolidatedMetricEvent,
    const EventSet& neededEvents);

MetricVec addEstimatedMissingMetrics(
    MetricVec&& sortedMetrics,
    chrono::TimePoint calculationDate);

MetricVec dropEstimationsInSlaWindow(
    MetricVec&& sortedMetrics,
    chrono::TimePoint calculationDate,
    chrono::Days sla);

MetricVec daysOutOfSlaInSlidingWindow(
    const MetricVec& metrics,
    Event event,
    size_t windowSize,
    double quantile,
    bool inTrunk,
    const std::string& region,
    const std::string& userType);

MetricVec achievableSlaInSlidingWindow(
    const MetricVec& metrics,
    Event event,
    size_t windowSize,
    size_t brokenSlaBudget,
    double quantile,
    bool inTrunk,
    const std::string& region,
    const std::string& userType);

MetricVec getConsolidatedByDaysMetricsWithEstimations(
    const MetricVec& allMetrics,
    double quantile,
    bool inTrunk,
    const std::string& region,
    const std::string& userType,
    const Event& event,
    const maps::chrono::TimePoint& calculationDate);

} // namespace maps::wiki::user_edits_metrics::impl
