# pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <filesystem>
#include <optional>

namespace maps::wiki::user_edits_metrics {

using namespace std::string_literals;

struct Options
{
    struct DeploymentDaysOutOfSlaOptions {
        size_t window;
        double quantile;
        size_t brokenSlaBudget;

        friend std::istream& operator>>(std::istream& is, DeploymentDaysOutOfSlaOptions& ddsOptions);
    };
    using DeploymentDaysOutOfSlaOptionsVec = std::vector<DeploymentDaysOutOfSlaOptions>;

    std::string configFname;
    std::chrono::seconds window;
    size_t singleMetricDepth;
    size_t totalDepth;
    std::vector<double> quantiles;
    DeploymentDaysOutOfSlaOptionsVec dds;
    std::optional<std::filesystem::path> dumpDir;
    maps::chrono::TimePoint calculationDate;
    bool upload;

    static Options parse(int argc, char** argv);
};

} // namespace maps::wiki::user_edits_metrics
