#pragma once

#include <maps/wikimap/mapspro/services/tasks_realtime/src/user_edits_metrics/lib/metrics_calculator.h>
#include <maps/wikimap/mapspro/services/tasks_realtime/src/user_edits_metrics/lib/util.h>
#include <maps/wikimap/mapspro/services/tasks_realtime/src/user_edits_metrics/lib/stat_utils/report_data_uploader.h>

#include <maps/wikimap/mapspro/libs/stat_client/include/report.h>

#include <maps/libs/chrono/include/days.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/introspection/include/comparison.h>

#include <chrono>
#include <optional>
#include <string>

namespace maps::wiki::user_edits_metrics {

using introspection::operator==;


class ConsolidatedDeploymentTimeDimensions {
public:
    ConsolidatedDeploymentTimeDimensions(
        chrono::TimePoint fielddate,
        Days days,
        std::string region,
        size_t userType,
        unsigned char percentile,
        bool inTrunk
    );

    auto introspect() const {
        return std::tie(fielddate_, days_, region_, userType_, percentile_, inTrunk_);
    }

    static void printHeader(csv::OutputStream& os);
    void print(csv::OutputStream& os) const;

    std::map<std::string, std::string> keyValues(pqxx::transaction_base& txn) const;

private:
    std::chrono::time_point<std::chrono::system_clock, chrono::Days> fielddate_;
    Days days_;
    std::string region_;
    size_t userType_;
    unsigned char percentile_;
    bool inTrunk_;
};


struct ConsolidatedDeploymentTimeMeasures {
    std::optional<std::chrono::seconds> total;
    std::optional<std::chrono::seconds> totalEstimated;

    static void printHeader(csv::OutputStream& os);
    void print(csv::OutputStream& os) const;

    std::map<std::string, std::string> keyValues() const;
};


class ConsolidatedDeploymentTimeReport:
    public stat_client::Report<
        ConsolidatedDeploymentTimeDimensions,
        ConsolidatedDeploymentTimeMeasures,
        stat_client::Scale::Daily
    >,
    public ReportDataUploader
{
public:
    ConsolidatedDeploymentTimeReport();
    void add(const RegionUserTypeToMetricVec& regionUserToMetrics);

    void upload(pqxx::transaction_base& txn) const;
};

} // namespace maps::wiki::user_edits_metrics
