#include "report_data_uploader.h"

namespace maps::wiki::user_edits_metrics {

void ReportDataUploader::uploadData(
    pqxx::transaction_base& txn,
    const std::map<std::string, std::string>& dimensionsData,
    const std::map<std::string, std::string>& measuresData) const
{
    std::string keys;
    std::string values;
    auto add = [&] (const std::map<std::string, std::string>& data) {
        for (const auto& [key, value] : data) {
            keys += (keys.empty() ? "" : ",") + key;

            values += values.empty() ? "" : ",";
            values += value.empty() ? "NULL" : value;
        }
    };

    add(dimensionsData);
    add(measuresData);

    std::string queryKeys;
    for (const auto& [key, value]: dimensionsData) {
        if (key.find("__") == std::string::npos) {
            queryKeys += (queryKeys.empty() ? "" : " AND ") + key + "=" + value;
        }
    }

    txn.exec(
        "DELETE FROM " + tableName_ + " WHERE " + queryKeys + "; "
        "INSERT INTO " + tableName_ + " (" + keys + ") VALUES (" + values + ")"
    );
}

} // namespace maps::wiki::user_edits_metrics
