#pragma once

#include <pqxx/pqxx>
#include <map>
#include <string>

namespace maps::wiki::user_edits_metrics {

class ReportDataUploader {
protected:
    explicit ReportDataUploader(const std::string& tableName)
        : tableName_(tableName)
    {}

    template <typename ReportData>
    void upload(
        pqxx::transaction_base& txn,
        const ReportData& dimensionsToMeasures) const
    {
        for (const auto& [dimensions, measures]: dimensionsToMeasures) {
            uploadData(txn, dimensions.keyValues(txn), measures.keyValues());
        }
    }

private:
    void uploadData(
        pqxx::transaction_base& txn,
        const std::map<std::string, std::string>& dimensionsData,
        const std::map<std::string, std::string>& measuresData) const;

    const std::string& tableName_;
};

} // namespace maps::wiki::user_edits_metrics
