#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/st/include/comment.h>
#include <maps/libs/st/include/gateway.h>
#include <maps/libs/st/include/issue.h>

#include <string>
#include <unordered_set>

namespace maps::wiki::user_edits_metrics {

/**
 * @brief Agent for work with Startrek
 */
class StAgent
{
public:
    StAgent(
        std::string queueKey,
        const std::string& token = getToken());

    st::Issue createIssue(
        const std::string& summary,
        const std::string& description,
        const std::unordered_set<std::string>& followers) const;

    std::optional<st::Issue> findOpenedIssue(const std::string& summary) const;

    void updateIssue(
        const st::Issue& issue,
        const std::string& comment,
        std::optional<chrono::TimePoint> newTagTime) const;
private:
    static std::string getToken();

    mutable st::Gateway stGateway_;
    const std::string queueKey_;
};

} // namespace maps::wiki::user_edits_metrics
