#include "st_tag.h"

#include <set>
#include <regex>

namespace maps::wiki::user_edits_metrics {

using namespace std::string_literals;

const auto TAG_PREFIX = "last_update_by_user_edits_metrics_"s;
const auto ISO_DATE_FORMAT = "%Y-%m-%d"s;

std::string timeToTag(const chrono::TimePoint &time)
{
    return TAG_PREFIX + maps::chrono::formatIsoDate(time);
}

maps::chrono::TimePoint tagsToDate(const std::unordered_set<std::string>& tags)
{
    std::set<maps::chrono::TimePoint> times;
    for (const auto& tag: tags) {
        if (tag.starts_with(TAG_PREFIX)) {
            const auto date = tag.substr(TAG_PREFIX.length());
            try {
                times.insert(maps::chrono::parseIsoDate(date));
            } catch (const maps::chrono::MalformedDateTime&) {}
        }
    }
    return times.empty() ? maps::chrono::TimePoint() : *(times.crbegin());
}

bool tagFormatCorrect(const std::string& tag) {
    if (tag.starts_with(TAG_PREFIX)) {
        return true;
    } else {
        return false;
    }
}

} // namespace maps::wiki::user_edits_metrics