#include "stat_util.h"

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::user_edits_metrics {

namespace {
/// @see https://stat.yandex-team.ru/DictionaryEditor/nmaps_deployment_user_type
const std::unordered_map<std::string, size_t> USER_TYPE_TO_STAT_DICT_VALUE = {
    {USER_TYPE_TRUSTED,    0},
    {USER_TYPE_COMMON,     1},
    {USER_TYPE_NON_YANDEX, 2},
    {USER_TYPE_YANDEX,     3}
};
} // namespace


size_t
userTypeToStatDictValue(const std::string& userType) {
    const auto it = USER_TYPE_TO_STAT_DICT_VALUE.find(userType);

    REQUIRE(
        it != USER_TYPE_TO_STAT_DICT_VALUE.cend(),
        "Unsupported user type: '" << userType << "'"
    );

    return it->second;
}

const std::string&
statDictValueToUserType(size_t userType) {
    for (const auto& [str, num] : USER_TYPE_TO_STAT_DICT_VALUE) {
        if (num == userType) {
            return str;
        }
    }

    throw maps::RuntimeError() <<
        "Unsupported numeric user type: '" << userType << "'";
}


/// @see https://stat.yandex-team.ru/DictionaryEditor/nmaps_deployment_days
size_t
daysToStatDictValue(Days days) {
    return static_cast<std::underlying_type_t<Days>>(days);
}

} // namespace maps::wiki::user_edits_metrics
