#pragma once

#include <maps/wikimap/mapspro/services/tasks_realtime/src/user_edits_metrics/lib/util.h>

#include <maps/wikimap/mapspro/libs/stat_client/include/report.h>

#include <maps/libs/http/include/exception.h>
#include <maps/libs/log8/include/log8.h>

#include <pqxx/pqxx>

#include <filesystem>
#include <fstream>
#include <string>

namespace maps::wiki::user_edits_metrics {

template <typename Report>
void
uploadReportToStatDb(
    pqxx::transaction_base& txn,
    const Report& report)
{
    INFO() << "Uploading report '" << report.name << "' to stat db";

    try {
        report.upload(txn);
        INFO() << "Report succesfully uploaded.";
    } catch (const maps::Exception& e) {
        ERROR() << "Upload error: " << e;
    } catch (const std::exception& e) {
        ERROR() << "Upload error: " << e.what();
    }
}

template <typename Report>
void
saveReport(const Report& report, const std::filesystem::path& filename)
{
    std::ofstream file(filename.c_str());
    csv::OutputStream outCsv(file);
    report.print(outCsv);
}

size_t userTypeToStatDictValue(const std::string& userType);
const std::string& statDictValueToUserType(size_t userType);

size_t daysToStatDictValue(Days days);

} // namespace maps::wiki::user_edits_metrics
