#pragma once

#include <maps/libs/chrono/include/time_point.h>

#include <boost/date_time/gregorian/gregorian.hpp>

#include <chrono>
#include <set>

namespace maps::wiki::user_edits_metrics {

const std::string HOLIDAYS_DATA_RESOURCE_KEY = "/wiki-user-edits-metrics-holidays.txt";
const std::string WORKDAYS_DATA_RESOURCE_KEY = "/wiki-user-edits-metrics-workdays.txt";

std::chrono::seconds computeDurationMinusWeekends(chrono::TimePoint startTime, chrono::TimePoint endTime);

std::set<boost::gregorian::date> parseDates(const std::string& data);

bool isHoliday(chrono::TimePoint date);

} // namespace maps::wiki::user_edits_metrics
