import argparse

from maps.wikimap.mapspro.services.tasks_realtime.src.user_edits_metrics.monitoring.lib import settings, stat_data, utils
from yandex.maps.wiki import config, db


def parse_args():
    parser = argparse.ArgumentParser(
        description="User edits processing metrics monitoring. "
        "Needs STATFSACE_TOKEN environment variable.")
    parser.add_argument(
        '--config', type=str,
        help='full path to services.xml')
    parser.add_argument(
        "--check-report",
        choices=[
            "consolidated-deployment-time",
            "deployment-sla",
            "user-edits-pocessing-metrics"
        ],
        required=True,
        help="Type of check: one of reports which user_edits_metrics updates"
    )
    return parser.parse_args()


def main():
    args = parse_args()
    try:
        report_checks = settings.CHECKS[args.check_report]
        config.init_config(args.config)
        db.init_pool(['stat'], 'tasks')
        with db.get_read_session('stat') as session:
            loader = stat_data.StatData(session, report_checks.table)
            issues = utils.find_issues(report_checks.checks, loader, report_checks.scale)
            print(utils.make_text(issues, report_checks.table))
    except Exception as e:
        print("2; Exception occured: {}".format(e))
        raise e
