from collections import namedtuple

ReportChecks = namedtuple("ReportChecks", ["table", "scale", "checks"])
SingleCheck = namedtuple("SingleCheck", ["dimensions", "measures", "levels"])
LevelInfo = namedtuple("LevelInfo", ["period", "kind"])

SECONDS_IN_DAY = 24 * 3600

DATA_MEASURES = [
    "bicycle_graph",
    "cameras",
    "carparks",
    "geocoder",
    "graph",
    "mtr_export",
    "pedestrian_graph",
    "renderer",
]

BROKEN_SLA_MEASURES = [
    "{}_broken_sla".format(m) for m in DATA_MEASURES
] + [
    "broken_sla",
]
REAL_SLA_MEASURES = [
    "{}_real_sla".format(m) for m in DATA_MEASURES
] + [
    "real_sla",
]

CHECKS = {
    "consolidated-deployment-time": ReportChecks(
        table="mapspro.consolidated_deployment_time",
        scale="d",
        checks=[
            SingleCheck(
                dimensions={
                    "days": [0, 1],
                    "region": ["moscow", "cis1", "all_regions"],
                    "user_type": [0, 1, 2],
                    "percentile": [85, 95],
                    "in_trunk": [1]
                },
                measures=[
                    "total"
                ],
                levels=[
                    LevelInfo(
                        period=5,
                        kind="warn"
                    ),
                    LevelInfo(
                        period=9,
                        kind="crit"
                    )
                ]
            )
        ]
    ),
    "deployment-sla": ReportChecks(
        table="mapspro.deployment_sla",
        scale="d",
        checks=[
            SingleCheck(
                dimensions={
                    "days": [0, 1],
                    "region": ["cis1", "all_regions"],
                    "user_type": [0, 1, 2],
                    "percentile": [85, 95],
                    "in_trunk": [1],
                    "window": [10],
                    "budget": [2],
                },
                measures=BROKEN_SLA_MEASURES,
                levels=[
                    LevelInfo(
                        period=6,
                        kind="warn"
                    ),
                    LevelInfo(
                        period=9,
                        kind="crit"
                    )
                ]
            ),
            SingleCheck(
                dimensions={
                    "days": [0, 1],
                    "region": ["cis1", "all_regions"],
                    "user_type": [0, 1, 2],
                    "percentile": [85, 95],
                    "in_trunk": [1],
                    "window": [10],
                    "budget": [2],
                },
                measures=REAL_SLA_MEASURES,
                levels=[
                    LevelInfo(
                        period=2,
                        kind="warn"
                    ),
                    LevelInfo(
                        period=4,
                        kind="crit"
                    )
                ]
            ),
            SingleCheck(
                dimensions={
                    "days": [0, 1],
                    "region": ["cis1", "all_regions"],
                    "user_type": [0, 1, 2],
                    "percentile": [85, 95],
                    "in_trunk": [1],
                    "window": [30],
                    "budget": [5],
                },
                measures=BROKEN_SLA_MEASURES,
                levels=[
                    LevelInfo(
                        period=6,
                        kind="warn"
                    ),
                    LevelInfo(
                        period=9,
                        kind="crit"
                    )
                ]
            ),
            SingleCheck(
                dimensions={
                    "days": [0, 1],
                    "region": ["cis1", "all_regions"],
                    "user_type": [0, 1, 2],
                    "percentile": [85, 95],
                    "in_trunk": [1],
                    "window": [30],
                    "budget": [5],
                },
                measures=REAL_SLA_MEASURES,
                levels=[
                    LevelInfo(
                        period=2,
                        kind="warn"
                    ),
                    LevelInfo(
                        period=4,
                        kind="crit"
                    )
                ]
            ),
        ]
    ),
    "user-edits-pocessing-metrics": ReportChecks(
        table="mapspro.user_edits_processing_times",
        scale="s",
        checks=[
            SingleCheck(
                dimensions={
                    "days": [0, 1],
                    "region": ["moscow", "cis1", "all_regions"],
                    "user_type": [0, 1, 2],
                    "percentile": [50],
                    "in_trunk": [1]
                },
                measures=DATA_MEASURES,
                levels=[
                    LevelInfo(
                        period=7 * SECONDS_IN_DAY,
                        kind="warn"
                    )
                ]
            ),
            SingleCheck(
                dimensions={
                    "days": [0, 1],
                    "region": ["cis1", "all_regions"],
                    "user_type": [0, 1, 2],
                    "percentile": [50, 85, 95],
                    "in_trunk": [1]
                },
                measures=[
                    "approved",
                    "exported",
                    "in_stable",
                    "resolved",
                ],
                levels=[
                    LevelInfo(
                        period=5 * SECONDS_IN_DAY,
                        kind="warn"
                    ),
                    LevelInfo(
                        period=9 * SECONDS_IN_DAY,
                        kind="crit"
                    )
                ]
            ),
        ]
    ),
}
