class StatData(object):
    def __init__(self, session, table):
        self.__session = session
        self.__table = table

    def download_data(self, scale, _period_distance, _measures, **kwargs):
        filters=''
        for key, value in kwargs.items():
            filters = filters + " AND \"{}\" = '{}'".format(key, value)

        min_date = "NOW() - interval '{} {}'".format(_period_distance, scale)
        if scale == 'd':
            min_date = "date({})".format(min_date)

        query = "SELECT " + ','.join(_measures) + " FROM " + self.__table \
            + " WHERE fielddate >= " + min_date + filters
        data = []
        for row in self.__session.execute(query):
            row_dict = {}
            for i, measure in enumerate(_measures):
                row_dict[measure] = row[i]
            data.append(row_dict)
        return data
