from maps.wikimap.mapspro.services.tasks_realtime.src.user_edits_metrics.monitoring.lib import settings, utils


def test_make_text():
    dimensions_slice = {"dim1": 1, "dim2": 2}

    issue1 = utils.Issue(dimensions=dimensions_slice, measure=None,       period=1, scale="d")
    issue2 = utils.Issue(dimensions=dimensions_slice, measure="measure1", period=2, scale="d")
    issue3 = utils.Issue(dimensions=dimensions_slice, measure="measure2", period=3, scale="d")

    crit_issues = {"crit": [issue1, issue2], "warn": [issue3], "wrong": [issue3]}
    assert utils.make_text(crit_issues, "test_schema.report_table") == "2;Critical: " \
        "No data for dimensions {'dim1': 1, 'dim2': 2} in period 1d;\n" \
        "No data for dimensions {'dim1': 1, 'dim2': 2} of measure measure1 in period 2d " \
        "in stat db: test_schema.report_table"

    warn_issues = {"warn": [issue1]}
    assert utils.make_text(warn_issues, "test_schema.report_table") == "1;Warning: " \
        "No data for dimensions {'dim1': 1, 'dim2': 2} in period 1d " \
        "in stat db: test_schema.report_table"

    no_issues = {"crit": []}
    assert utils.make_text(no_issues, "test_schema.report_table") == "0;OK in stat db: test_schema.report_table"


def test_get_never_met_measures():
    assert utils.get_never_met_measures(data=[], checked_measures=["m1", "m2"]) == {"m1", "m2"}

    assert utils.get_never_met_measures(
        data=[
            {"m1": 1, "m2": None},
            {"m1": None, "m3": 1},
        ],
        checked_measures=["m1", "m2"]) == {"m2"}

    assert utils.get_never_met_measures(
        data=[
            {"m1": 1, "m2": False},
        ],
        checked_measures=["m1", "m2"]) == set()


class MockReport(object):
    def __init__(self):
        self.ALL_DATA = [
            # real report has different fieelddate for the same dimensions slice
            {"d1": 1, "d2": 1, "m1": 1,    "m2": None},
            {"d1": 1, "d2": 1, "m1": None, "m2": 2},
            {"d1": 2, "d2": 1, "m1": 1,    "m2": 2},
            {"d1": 2, "d2": 2, "m1": 1,    "m2": None},
            {"d1": 2, "d2": 2, "m1": None, "m2": None},
            {"d1": 3, "d2": 3, "m1": 1,    "m2": None},
        ]

    def download_data(self, scale, _period_distance, _measures, **kwargs):
        return list(filter(
            lambda row: all(row.get(k) == v for k, v in kwargs.items()),
            self.ALL_DATA
        ))


def test_find_issues_by_check_all_slices_have_all_measures():
    assert utils.find_issues_by_check(
        check=settings.SingleCheck(
            dimensions={
                "d1": [1, 2],
                "d2": [1],
            },
            measures=["m1", "m2"],
            levels=[settings.LevelInfo(period=9, kind="crit"), settings.LevelInfo(period=9, kind="warn")]
        ),
        report=MockReport(),
        scale='d'
    ) == {"warn": [], "crit": []}


def test_find_issues_by_check_slice_has_part_of_measures():
    assert utils.find_issues_by_check(
        check=settings.SingleCheck(
            dimensions={
                "d1": [2],
                "d2": [2],
            },
            measures=["m1", "m2"],
            levels=[settings.LevelInfo(period=5, kind="crit")]
        ),
        report=MockReport(),
        scale='d'
    ) == {
        "crit": [
            utils.Issue(dimensions={"d1": 2, "d2": 2}, measure="m2", period=5, scale="d"),
        ],
    }


def test_find_issues_by_check_slice_has_no_needed_measures_and_empty_slice():
    assert utils.find_issues_by_check(
        check=settings.SingleCheck(
            dimensions={
                "d1": [3],
                "d2": [3, 4],
            },
            measures=["m2"],
            levels=[settings.LevelInfo(period=5, kind="warn")]
        ),
        report=MockReport(),
        scale='d'
    ) == {
        "warn": [
            utils.Issue(dimensions={"d1": 3, "d2": 3}, measure="m2", period=5, scale="d"),
            utils.Issue(dimensions={"d1": 3, "d2": 4}, measure=None, period=5, scale="d"),
        ]
    }


def test_find_issues():
    assert utils.find_issues(
        checks=[
            settings.SingleCheck(
                dimensions={
                    "d1": [3],
                    "d2": [3, 4],
                },
                measures=["m2"],
                levels=[settings.LevelInfo(period=5, kind="warn")]
            ),
            settings.SingleCheck(
                dimensions={
                    "d1": [2],
                    "d2": [2],
                },
                measures=["m1", "m2"],
                levels=[settings.LevelInfo(period=5, kind="crit")]
            )
        ],
        report=MockReport(),
        scale='d'
    ) == {
        "crit": [
            utils.Issue(dimensions={"d1": 2, "d2": 2}, measure="m2", period=5, scale="d"),
        ],
        "warn": [
            utils.Issue(dimensions={"d1": 3, "d2": 3}, measure="m2", period=5, scale="d"),
            utils.Issue(dimensions={"d1": 3, "d2": 4}, measure=None, period=5, scale="d"),
        ],
    }
