#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/services/tasks_realtime/src/user_edits_metrics/lib/metrics.h>

namespace maps::wiki::user_edits_metrics::tests {

using namespace std::literals::string_literals;
using namespace std::literals::chrono_literals;

namespace in_trunk {
const auto YES = true;
const auto NO = false;
}

const auto DEFAULT_VALUE = 1h;
const auto DEFAULT_WORKDAYS_VALUE = 3h;
const auto DEFAULT_QUANTILE = 0.85;
const auto DEFAULT_REGION = "region"s;
const auto DEFAULT_USER_TYPE = USER_TYPE_COMMON;
const auto DEFAULT_EVENT = Event::Approved;

class MetricCreator {
public:
    Metric operator() () {
        return metric_;
    }

    MetricCreator& time(chrono::TimePoint newTime) {
        metric_.time = newTime;
        return *this;
    }

    MetricCreator& time(const std::string& sqlTimeValue) {
        return time(chrono::parseSqlDateTime(sqlTimeValue));
    }

    MetricCreator& value(std::chrono::seconds newValue) {
        metric_.value = newValue;
        return *this;
    }

    MetricCreator& workdaysValue(std::chrono::seconds newWorkdaysValue) {
        metric_.workdaysValue = newWorkdaysValue;
        return *this;
    }

    MetricCreator& quantile(double newValue) {
        metric_.quantile = newValue;
        return *this;
    }

    MetricCreator& region(std::string newValue) {
        metric_.region = std::move(newValue);
        return *this;
    }

    MetricCreator& userType(std::string newValue) {
        metric_.userType = std::move(newValue);
        return *this;
    }

    MetricCreator& event(Event newValue) {
        metric_.event = newValue;
        return *this;
    }

    MetricCreator& inTrunk(bool newInTrunk) {
        metric_.inTrunk = newInTrunk;
        return *this;
    }

    MetricCreator& estimated() {
        metric_.estimated = Metric::Estimated::Yes;
        return *this;
    }

private:
    Metric metric_ = {
        .time = chrono::parseSqlDateTime("2019-06-01 00:00:00"),
        .value = DEFAULT_VALUE,
        .workdaysValue = DEFAULT_WORKDAYS_VALUE,
        .quantile = DEFAULT_QUANTILE,
        .region = DEFAULT_REGION,
        .userType = DEFAULT_USER_TYPE,
        .event = DEFAULT_EVENT,
        .inTrunk = in_trunk::YES,
        .estimated = Metric::Estimated::No
    };
};

} // namespace maps::wiki::user_edits_metrics::tests {