#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/libs/assessment/include/sample.h>
#include <maps/wikimap/mapspro/services/tasks_social/src/assessment_sampler/lib/make_expert_sample.h>

struct Params
{
    maps::wiki::assessment::Entity::Domain domain;
    maps::wiki::assessment::Qualification qualification;
    maps::chrono::TimePoint date;
    size_t days;
    bool dryRun;
    bool allowDuplicateSample;
    size_t seed;
    std::string name;

    std::optional<std::string> syslogTag;
    std::optional<std::string> workerConfigPath;

    maps::wiki::assessment::sampler::StaffType staffType;
    maps::wiki::assessment::sampler::HypothesesMode hypothesesMode;

    void log(maps::log8::Level level) const;
};

Params parseCommandLineParams(int argc, char* argv[]);
