#!/bin/bash

DAYS=$1

# Attention! Keep this array in sync with maps from limits.cpp
MODES=(
    #Domain     Staff type   Hypotheses
    'edits      staff        no'
    'edits      piecework    no'
    'edits      outsource    no'
    'moderation staff        no'
    'moderation piecework    no'
    'feedback   staff        no'
    'feedback   piecework    no'
    'feedback   staff        yes'
    'feedback   piecework    yes'
    'feedback   outsource    yes'
    'tracker    staff        no'
);

for qualification in 'basic' 'expert'; do
    for mode in "${MODES[@]}"; do
        read domain staff_type hypotheses <<< $mode

        if [ $hypotheses == 'yes' ]; then
            hypotheses='--hypotheses'
        else
            hypotheses=''
        fi

        /usr/bin/wiki-assessment-sampler \
            --syslog-tag=wiki-assessment-sampler --days $DAYS \
            --qualification $qualification --domain $domain --staff-type $staff_type $hypotheses
    done
done
