#include "grouped_units.h"

namespace maps::wiki::assessment::sampler {

GroupNameToUnits&
operator+=(GroupNameToUnits& lhs, GroupNameToUnits&& rhs)
{
    while (!rhs.empty()) {
        auto rhsIt = rhs.begin();
        const auto& groupName = rhsIt->first;
        if (auto lhsIt = lhs.find(groupName); lhsIt != lhs.cend()) {
            auto& rhsUnits = rhsIt->second;
            auto& lhsUnits = lhsIt->second;
            lhsUnits.reserve(lhsUnits.size() + rhsUnits.size());
            std::move(rhsUnits.begin(), rhsUnits.end(), std::back_inserter(lhsUnits));
            rhs.erase(rhsIt);
        } else {
            lhs.insert(rhs.extract(rhsIt));
        }
    }

    return lhs;
}

} // maps::wiki::assessment::sampler
