#include "init.h"

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/default_config.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/pg_advisory_lock_ids.h>

namespace maps::wiki::assessment::sampler {

common::PoolHolder initPoolHolder(const std::string& dbId, const std::optional<std::string>& path)
{
    static const std::string GRINDER_POOL_ID = "grinder";

    const auto configDocPtr = path
        ? std::make_unique<common::ExtendedXmlDoc>(*path)
        : common::loadDefaultConfig();

    return common::PoolHolder(*configDocPtr, dbId, GRINDER_POOL_ID);
}

pgp3utils::PgAdvisoryXactMutex initSocialLocker(pgpool3::Pool& socialPool)
{
    const auto lockId = common::AdvisoryLockIds::ASSESSMENT_SAMPLER;
    return pgp3utils::PgAdvisoryXactMutex(socialPool, static_cast<int64_t>(lockId));
}

} // namespace maps::wiki::assessment::sampler
