#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/common.h>
#include <maps/libs/log8/include/log8.h>

#include <random>
#include <string>
#include <vector>

namespace maps::wiki::assessment::sampler::impl {

struct UnitGroups {
    std::vector<TId> inconsistent;
    std::vector<TId> consistent;
    std::vector<TId> notGraded;

    size_t totalUnitCount() const;
    void logStats(maps::log8::Level level, const std::string& sampleName) const;
};

std::vector<TId>
pickExpertUnits(
    std::mt19937& rndGen,
    UnitGroups&& unitGroups,
    double unitsRatio,
    double inconsistentUnitsRatio);

} // maps::wiki::assessment::sampler::impl
