#pragma once

#include "grouped_units.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/introspection/include/comparison.h>
#include <maps/wikimap/mapspro/libs/assessment/include/console.h>


namespace maps::wiki::assessment::sampler {

enum class StaffType {
    Staff,
    Piecework,
    Outsource
};
DECLARE_ENUM_IO(StaffType);

enum class HypothesesMode: bool {
    Yes = true,
    No = false
};

struct Mode {
    Entity::Domain domain;
    StaffType      staffType;
    HypothesesMode hypothesesMode;

    auto introspect() const {
        return std::tie(domain, staffType, hypothesesMode);
    }
};

using maps::introspection::operator<;
using maps::introspection::operator==;

void makeSample(
    assessment::Gateway& assessmentGw,
    Entity::Domain domain,
    Qualification qualification,
    const std::string& sampleName,
    const std::vector<TId>& unitIds,
    size_t tasksPerUnit);

std::string sampleName(
    Entity::Domain domain,
    Qualification qualification,
    chrono::TimePoint lastDate,
    size_t days,
    StaffType staffType,
    HypothesesMode hypothesesMode);

} // maps::wiki::assessment::sampler
